<?php
header('Content-Type: text/plain; charset=utf-8');

// --- CONFIGURATION ---
$REQUIRED_SECRET = '';
$REQUIRE_SECRET  = false;

// --- HELPERS ---
function bad($msg='Bad request', $code=400){
    http_response_code($code);
    echo "FAILED: $msg";
    exit;
}
function ok($msg='OK'){ echo $msg; exit; }
function sanitize($val){ return trim(preg_replace("/[\r\n]/"," ",$val)); }
function safe_email($email){ return filter_var(trim($email), FILTER_VALIDATE_EMAIL) ?: false; }
function randomBase62(int $length = 26): string {
    $chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $buf = random_bytes($length);
    $out = '';
    for ($i = 0; $i < $length; $i++) {
        // map each byte (0..255) down to 0..61
        $out .= $chars[ord($buf[$i]) % 62];
    }
    return $out;
}

function makeUnsubscribeEmail($email) {
    // Validate it’s a real email before wrecking it
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return false;
    }
    
    // Split the email into user and domain
    $parts = explode('@', $email);
    if (count($parts) !== 2) {
        return false;
    }
    
    // Replace the user part with "unsubscribe"
    return 'unsubscribe@' . $parts[1];
}


// --- HANDLE UNSUB PAGE ---
if (isset($_POST['maili'])) {
    header('Content-Type: text/html; charset=utf-8');
    $token_or_email = htmlspecialchars($_POST['maili'], ENT_QUOTES, 'UTF-8');
    echo "<center><h2>Unsubscribed successfully.</h2><p>{$token_or_email}</p></center>";
    exit;
}

if (isset($_GET['unsub'])) {
    header('Content-Type: text/html; charset=utf-8');
    $prefilled = htmlspecialchars($_GET['unsub'], ENT_QUOTES, 'UTF-8');
    echo "
<!DOCTYPE html>
<html lang='en'>
<head>
<meta charset='UTF-8'>
<title>Unsubscribe</title>
<style>
body {
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background: #f5f5f5;
  font-family: 'Arial', sans-serif;
}
form {
  background: #fff;
  padding: 20px 25px;
  border-radius: 12px;
  box-shadow: 0 4px 15px rgba(0,0,0,0.1);
  display: flex;
  flex-direction: column;
  gap: 12px;
  width: 250px;
}
input[type='email'] {
  padding: 10px;
  border-radius: 8px;
  border: 1px solid #ccc;
  outline: none;
  transition: all 0.2s;
}
input[type='email']:focus {
  border-color: #0084ff;
  box-shadow: 0 0 5px rgba(0,132,255,0.5);
}
button {
  padding: 10px;
  border: none;
  border-radius: 8px;
  background: linear-gradient(90deg, #0084ff, #00c6ff);
  color: #fff;
  font-weight: bold;
  cursor: pointer;
  transition: transform 0.2s, box-shadow 0.2s;
}
button:hover {
  transform: translateY(-2px);
  box-shadow: 0 5px 15px rgba(0,132,255,0.3);
}
</style>
</head>
<body>
<form method='post'>
  <input type='email' name='maili' placeholder='Enter your email' value='{$prefilled}' required>
  <button type='submit'>Unsubscribe</button>
</form>
</body>
</html>
";
    exit;
}

// --- METHOD CHECK ---
if ($_SERVER['REQUEST_METHOD'] !== 'POST') bad('Method not allowed',405);

// --- SECRET PROTECTION ---
if ($REQUIRE_SECRET) {
    $secret = $_POST['secret'] ?? '';
    if ($secret !== $REQUIRED_SECRET) bad('Forbidden',403);
}

// --- INPUTS ---
$to        = safe_email($_POST['to'] ?? '');
$subject   = sanitize($_POST['subject'] ?? '(no subject)');
$from_name = sanitize($_POST['from_name'] ?? '');
$html      = $_POST['html'] ?? '';

if (!$to || !$html) bad('Missing to/html');

// --- DETECT SERVER EMAIL ---
$from_email_safe = '';
if (ini_get('sendmail_from')) {
    $from_email_safe = ini_get('sendmail_from');
} elseif (function_exists('posix_getpwuid')) {
    $user = posix_getpwuid(posix_geteuid())['name'];
    $host = $_SERVER['SERVER_NAME'] ?? 'localhost';
    $from_email_safe = "$user@$host";
}

// --- BUILD HEADERS & BODY ---
$protocol    = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$host        = $_SERVER['HTTP_HOST'] ?? 'localhost';
$script_dir  = rtrim(dirname($_SERVER['SCRIPT_NAME']), "/\\");
$unsubscribe_url = $protocol . "://" . $host . $script_dir . "/unsubscribe.php?unsub=" . urlencode($to);
$id = bin2hex(random_bytes(8)) . '.' . microtime(true);
$message_id = sprintf('<%s@%s>', $id, $host);

$randomiddd = randomBase62();
$unsuuu = "
<hr style='border:none;border-top:1px solid #eee;margin-top:40px;margin-bottom:20px;'>
<p style='text-align:center;padding-bottom:20px;color:#777'>
  <a href='{$unsubscribe_url}'
     style='display:inline-block;padding:10px 20px;font-size:13px;color:#777;
            text-decoration:none;border-radius:4px;border:1px solid #ddd;'>
    Unsubscribe
  </a>
  <span style='
    display: block;
    padding-top: 10px;
'>
  ID #$randomiddd</span>
  </p>
";

//$tracking_pixel = "<img src='{$protocol}://{$host}{$script_dir}/track.php?m=" . urlencode($to) . "' width='1' height='1' style='display:none'>";
$tracking_pixel = "";
$body = $html . $unsuuu . $tracking_pixel;
$loisfii = makeUnsubscribeEmail($from_email_safe); 

$full_headers = [];
$full_headers[] = "From: " . ($from_name ? "{$from_name} <{$from_email_safe}>" : $from_email_safe);
$full_headers[] = "To: {$to}";
$full_headers[] = "Reply-To: {$from_email_safe}";
$full_headers[] = "Return-Path: {$from_email_safe}";
$full_headers[] = "Date: " . date(DATE_RFC2822);
$full_headers[] = "Message-ID: {$message_id}";
$full_headers[] = "MIME-Version: 1.0";
$full_headers[] = "Content-Type: text/html; charset=UTF-8";
$full_headers[] = "X-Mailer: PHP/" . phpversion();
$full_headers[] = "List-Unsubscribe: <{$unsubscribe_url}>, <mailto:{$loisfii}?subject=unsubscribe>";
$full_headers[] = "List-Unsubscribe-Post: List-Unsubscribe=One-Click";



// Encode subject properly
$encoded_subject = "=?UTF-8?B?" . base64_encode($subject) . "?=";

// --- SEND MAIL USING SENDMAIL ---
$sendmail = '/usr/sbin/sendmail -oi -t -f ' . escapeshellarg($from_email_safe);
$proc = popen($sendmail, 'w');
if ($proc) {
    fwrite($proc, "To: {$to}\r\n");
    fwrite($proc, "Subject: {$encoded_subject}\r\n");
    fwrite($proc, implode("\r\n", $full_headers) . "\r\n\r\n");
    fwrite($proc, $body);
    pclose($proc);

    // --- Log ---
    //file_put_contents('sent_log.txt', date('Y-m-d H:i:s') . " | {$to} | {$subject}\n", FILE_APPEND);

    ok('OK');
} else {
    bad('Failed to execute sendmail',500);
}
?>
